<!--
This file guides AI coding agents (Copilot/GPT-based assistants) when working in
this repository. It was generated automatically because no existing agent
instructions were found. Update it with repository-specific examples when ready.
-->
# Copilot / AI Agent Instructions

Purpose: Help an AI agent become productive quickly by outlining discovery
steps, important files to inspect, common commands, and project-specific
checks. This repo had no discoverable source files at the time this file was
created — run the discovery checklist below before making code changes.

1) First actions (always run)
- List tracked files: `git ls-files --exclude-standard` or `dir /b` on Windows.
- Search for key project files: look for `composer.json`, `package.json`, `README.md`, `index.php`, `public/`, `src/`, `app/`, `.env`, `Dockerfile`, `docker-compose.yml`, and `.github/workflows/`.
- If `composer.json` exists: run `composer install` (Windows: use the PHP/composer in PATH).
- If `package.json` exists: run `npm ci` or `yarn install`.
- If `docker-compose.yml` exists and you need a full stack: run `docker-compose up -d`.

2) Architecture discovery checklist
- Identify the entrypoint: look for `index.php`, `public/index.php`, `server.js`, or `src/main`.
- Inspect `composer.json` / `package.json` to understand frameworks, scripts, and important dependencies.
- Look for framework conventions: `app/`, `routes/`, `controllers/`, `views/` → typical PHP frameworks; `src/`, `lib/`, `routes/` → Node apps.
- Check for DB config in `.env`, `config/`, or `settings.php`. Note connection strings and migration tooling.
- Look for tests: `phpunit.xml`, `tests/`, `spec/`, or `jest.config.js`. Use `vendor/bin/phpunit` or `npm test` accordingly.

3) Critical developer workflows
- Local dev server: if a `public/` folder exists, the app may be served by Apache (AppServ). For Laravel-like projects use `php artisan serve` if present.
- Asset build: `npm run dev` / `npm run build` when `package.json` contains `scripts` for building front-end assets.
- Database migrations: look for `migrations/` or commands in `composer.json` / `package.json` scripts. Prefer running migrations in a disposable environment (docker or local DB dump) when possible.

4) Project-specific patterns to detect
- PSR-4 / autoload: check `composer.json` -> `autoload` to map namespaces to paths.
- If `routes/` contains many small files, prefer modifying routes there rather than editing a large monolithic router.
- If a `public` directory contains static assets, keep build outputs out of `src/` and respect the repo's existing asset pipeline.

5) Integration points and external dependencies
- External services (APIs, S3, SMTP): search `.env` or `config` for hostnames or API keys.
- CI workflows: inspect `.github/workflows/` for test / lint commands. Mirror those commands locally when possible.

6) Safe edit rules for AI agents (apply these before making changes)
- Do not change `composer.json` / `package.json` dependency versions without an explicit task.
- If tests exist, run the full test suite before opening a PR. If tests are absent, run linters or basic build steps.
- Keep configuration secrets out of commits. If an example `.env.example` exists, mirror its pattern for local testing.

7) If the repository is empty or missing context
- Stop and request these items from a human: a short README describing project type (framework, language), local dev commands, and any DB or external services required.

8) Where to look for examples
- Look at `README.md` for owner-provided usage and environment notes.
- Look at `composer.json` / `package.json` for scripts and dependency hints.

If anything in this file is unclear or you want the instructions tailored to a detected framework (Laravel, Symfony, plain PHP, Node, etc.), reply with the repository's key files (paste `composer.json` or `package.json`) and I will merge framework-specific guidance into this file.
