(function () {
  var defaults = {
    event_title: "Boda Tradicional Catolica",
    main_message: "Con la bendicion de Dios y de nuestros padres, queremos compartir este gran dia contigo.",
    main_person_name: "Valeria",
    secondary_person_name: "Emiliano",
    event_date: "18 Diciembre 2026",
    event_time: "18:00 hrs",
    salon_name: "Salon Jardin Aurora",
    event_address: "Av. Principal 123, CDMX",
    ceremony_place: "Parroquia San Miguel Arcangel",
    ceremony_time: "17:00",
    dress_code: "Formal elegante",
    rsvp_deadline: "05 Diciembre 2026",
    contact_whatsapp: "+52 55 0000 0000",
    maps_url: "https://maps.google.com",
    rsvp_url: "#",
    gift_table: "Tu presencia es nuestro mejor regalo.",
    padrinos_names: "Nombre de padrinos",
    parents_names: "Familiares de los festejados",
    photo_main: "./assets/boda-floral.png",
    photo_ceremony: "./assets/boda-floral-alt.png",
    photo_gallery1: "./assets/boda-floral.png",
    photo_gallery2: "./assets/boda-floral-alt.png",
    photo_gallery3: "./assets/boda-floral.png",
    music_url: "./media/background.mp3"
  };

  var params = new URLSearchParams(window.location.search);
  var data = Object.assign({}, defaults);
  Object.keys(defaults).forEach(function (k) {
    var v = params.get(k);
    if (v !== null && v !== "") data[k] = v;
  });

  function setText(id, value) {
    var el = document.getElementById(id);
    if (el) el.textContent = value || "";
  }
  function setHref(id, value) {
    var el = document.getElementById(id);
    if (el && value) el.href = value;
  }
  function setSrc(id, value) {
    var el = document.getElementById(id);
    if (el && value) el.src = value;
  }

  setText("eventTitle", data.event_title);
  setText("mainMessage", data.main_message);
  setText("mainPersonName", data.main_person_name);
  setText("secondaryPersonName", data.secondary_person_name);
  setText("eventDate", data.event_date);
  setText("eventTime", data.event_time);
  setText("salonName", data.salon_name);
  setText("eventAddress", data.event_address);
  setText("ceremonyPlace", data.ceremony_place);
  setText("ceremonyTime", data.ceremony_time);
  setText("dressCode", data.dress_code);
  setText("rsvpDeadline", data.rsvp_deadline);
  setText("contactWhatsapp", data.contact_whatsapp);
  setText("giftTable", data.gift_table);
  setText("padrinosNames", data.padrinos_names);
  setText("parentsNames", data.parents_names);
  setSrc("photoMain", data.photo_main);
  setSrc("photoCeremony", data.photo_ceremony);
  setSrc("photoGallery1", data.photo_gallery1);
  setSrc("photoGallery2", data.photo_gallery2);
  setSrc("photoGallery3", data.photo_gallery3);
  setHref("mapsLink", data.maps_url);
  setHref("rsvpLink", data.rsvp_url);

  var waPhone = String(data.contact_whatsapp || "").replace(/[^0-9]/g, "");
  var waText = encodeURIComponent("Hola, confirmo mi asistencia. Gracias por la invitacion.");
  setHref("whatsAppLink", waPhone ? ("https://wa.me/" + waPhone + "?text=" + waText) : "#");

  var audio = document.getElementById("bgMusic");
  var toggle = document.getElementById("musicToggle");
  if (audio && toggle) {
    audio.src = data.music_url;
    audio.volume = 0.35;

    var syncState = function (on) {
      toggle.classList.toggle("is-on", !!on);
      toggle.textContent = on ? "Musica: On" : "Musica: Off";
    };

    var playAudio = function () {
      audio.play().then(function () {
        syncState(true);
      }).catch(function () {
        syncState(false);
      });
    };

    toggle.addEventListener("click", function () {
      if (audio.paused) {
        playAudio();
      } else {
        audio.pause();
        syncState(false);
      }
    });

    // Attempt autoplay quietly; if blocked user can start with button.
    playAudio();
  }
})();
