<?php include __DIR__ . '/header.php'; ?>
<div class="hero">
  <div>
    <h2>Tu Carrito</h2>
    <p>Revisa y confirma tus invitaciones antes de pagar</p>
  </div>
</div>

<?php if (empty($cart)): ?>
  <div class="card-tech empty-state">
    <svg width="64" height="64" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-bottom:20px;opacity:0.5"><path d="M9 2L6 6M15 2L18 6M3 6H21L19 20C19 20.5304 18.7893 21.0391 18.4142 21.4142C18.0391 21.7893 17.5304 22 17 22H7C6.46957 22 5.96086 21.7893 5.58579 21.4142C5.21071 21.0391 5 20.5304 5 20L3 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>
    <h3 class="muted" style="margin-bottom:20px">Tu carrito está vacío</h3>
    <a href="<?=htmlspecialchars($url('/'))?>" class="btn primary" style="display:inline-flex;width:auto">Ver Catálogo</a>
  </div>
<?php else:
  $total = 0;
  foreach ($cart as $pid => $qty) {
    $p = $cartProducts[(int)$pid] ?? null;
    if (!$p) continue;
    $subtotal = $p['price_cents'] * $qty;
    $total += $subtotal;
?>
  <div class="list-item">
    <div style="flex:1">
      <h3 class="title" style="margin:0 0 8px"><?=htmlspecialchars($p['title'])?></h3>
      <div class="muted" style="font-size:14px">Cantidad: <strong><?=$qty?></strong> × $<?=number_format($p['price_cents']/100,2)?></div>
    </div>
    <div style="text-align:right">
      <div style="font-weight:700;color:#7be5ff;font-size:16px;margin-bottom:8px">$<?=number_format($subtotal/100,2)?></div>
      <form method="post" action="<?=htmlspecialchars($url('/remove-from-cart'))?>">
        <input type="hidden" name="id" value="<?= (int)$pid ?>">
        <input type="hidden" name="qty" value="1">
        <button class="btn ghost" type="submit" style="padding:8px 10px;font-size:12px">Quitar 1</button>
      </form>
    </div>
  </div>
<?php } ?>
  <div class="card-tech" style="margin-top:20px">
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:20px;padding-bottom:20px;border-bottom:1px solid rgba(53,212,255,.2)">
      <div class="muted" style="font-size:16px">Subtotal:</div>
      <div style="font-weight:700;">$<?=number_format($total/100,2)?></div>
    </div>
    <div style="display:flex;justify-content:space-between;align-items:center;margin-bottom:24px">
      <div style="font-size:18px;font-weight:600">Total a pagar:</div>
      <div style="font-size:24px;font-weight:700;color:#7be5ff">$<?=number_format($total/100,2)?></div>
    </div>
    <?php if (!empty($checkoutRequiresAuth)): ?>
      <div class="notice error" style="margin-bottom:12px">
        Para continuar al pago, primero debes registrarte o iniciar sesión.
      </div>
      <div class="cta-row">
        <a class="btn primary" href="<?=htmlspecialchars($url('/register', ['next' => 'checkout']))?>">Registrarme</a>
        <a class="btn ghost" href="<?=htmlspecialchars($url('/login', ['next' => 'checkout']))?>">Ya tengo cuenta</a>
      </div>
    <?php else: ?>
      <form action="<?=htmlspecialchars($url('/checkout'))?>" method="post">
        <button class="btn primary" type="submit" style="width:100%;padding:14px">Proceder al Pago Seguro</button>
      </form>
    <?php endif; ?>
    <a href="<?=htmlspecialchars($url('/'))?>" class="muted" style="display:block;text-align:center;margin-top:12px;text-decoration:none;font-size:14px">Continuar comprando</a>
  </div>
<?php endif; ?>
<?php include __DIR__ . '/footer.php'; ?>
