<?php include __DIR__ . '/header.php'; ?>
<div class="panel-layout">
  <?php include __DIR__ . '/panel_sidebar.php'; ?>
  <section class="panel-main">
    <div class="hero">
      <div>
        <h2>Dashboard del Cliente</h2>
        <p>Hola, <?=htmlspecialchars($currentUser['name'] ?? 'Cliente')?>. Flujo: selecciona invitación, configura evento, carga invitados y envía.</p>
      </div>
    </div>

    <?php if (!empty($billingNotice)): ?>
      <div class="notice error" style="margin-bottom:14px"><?=htmlspecialchars($billingNotice)?></div>
    <?php endif; ?>
    <?php if (!empty($selectionNotice)): ?>
      <div class="notice ok" style="margin-bottom:14px"><?=htmlspecialchars($selectionNotice)?></div>
    <?php endif; ?>

    <?php if (!empty($accountAccess['is_locked'])): ?>
      <div class="notice error" style="margin-bottom:14px">
        Tu prueba de 4 días terminó. Para continuar con organización y envío de invitaciones, realiza tu pago.
      </div>
    <?php elseif (!empty($accountAccess)): ?>
      <div class="notice ok" style="margin-bottom:14px">
        <?=!empty($accountAccess['is_paid']) ? 'Cuenta con pago confirmado.' : 'Prueba activa: ' . (int)$accountAccess['trial_days_left'] . ' día(s) restantes.'?>
      </div>
    <?php endif; ?>

    <div class="card-tech" style="margin-bottom:16px">
      <h3 style="margin-top:0">Invitación seleccionada</h3>
      <?php if (!empty($selectedInvitation)): ?>
        <?php
          $resolveProductImage = static function ($rawImage) use ($url) {
            $rawImage = trim((string)$rawImage);
            if ($rawImage === '') {
              return '';
            }
            if (preg_match('#^(https?:)?//#i', $rawImage) || strpos($rawImage, 'data:') === 0) {
              return $rawImage;
            }
            if (strpos($rawImage, '/assets/') === 0) {
              return $url($rawImage);
            }
            return $url('/' . ltrim($rawImage, '/'));
          };
          $selectedProductTitle = (string)($selectedInvitation['title'] ?? 'Producto seleccionado');
          $selectedProductRawImage = trim((string)($selectedInvitation['image_url'] ?? ''));
          $resolvedSelectedImage = $resolveProductImage($selectedProductRawImage);
          $selectedProductImage = $resolvedSelectedImage !== '' ? $resolvedSelectedImage : $url('/assets/imagen2.png');
        ?>
        <a href="<?=htmlspecialchars((string)($invitePreviewUrl ?? '#'))?>" target="_blank" rel="noopener" style="display:grid;grid-template-columns:minmax(160px,220px) 1fr;gap:14px;align-items:center;margin-bottom:12px;text-decoration:none;color:inherit">
          <div style="border-radius:12px;overflow:hidden;border:1px solid rgba(53,212,255,.25);background:#071728">
            <img src="<?=htmlspecialchars($selectedProductImage)?>" alt="Producto seleccionado" style="width:100%;height:160px;object-fit:cover;display:block">
          </div>
          <div>
            <div class="muted" style="font-size:12px;text-transform:uppercase;letter-spacing:.08em;margin-bottom:6px">Producto escogido</div>
            <p style="margin:0 0 6px"><strong><?=htmlspecialchars($selectedProductTitle)?></strong></p>
            <p class="muted" style="margin:0 0 8px"><?=htmlspecialchars((string)($selectedInvitation['description'] ?? ''))?></p>
            <span class="btn ghost" style="display:inline-flex;max-width:260px">Abrir invitación web</span>
          </div>
        </a>
        <div class="cta-row">
          <a class="btn ghost" style="max-width:260px" href="<?=htmlspecialchars($url('/organizar-evento'))?>">Completar datos del evento</a>
          <a class="btn primary" style="max-width:260px" href="<?=htmlspecialchars($url('/'))?>">Cambiar invitación</a>
        </div>
      <?php else: ?>
        <p class="muted" style="margin:0 0 10px">Aún no seleccionas una invitación.</p>
        <a class="btn primary" style="max-width:220px" href="<?=htmlspecialchars($url('/'))?>">Ir al catálogo</a>
      <?php endif; ?>
    </div>

    <div class="stats-grid" style="margin-bottom:18px">
      <div class="stat-box">
        <div class="label">Pedidos</div>
        <div class="value"><?=count($orders)?></div>
      </div>
      <div class="stat-box">
        <div class="label">Email</div>
        <div style="font-size:16px;font-weight:600"><?=htmlspecialchars($currentUser['email'] ?? '')?></div>
      </div>
    </div>

    <?php if (empty($orders)): ?>
      <div class="card-tech">
        No tienes pedidos todavía. <a href="<?=htmlspecialchars($url('/'))?>">Ir al catálogo</a>
      </div>
    <?php else: ?>
      <div class="list-grid">
        <?php foreach ($orders as $o): ?>
          <div class="list-item">
            <div>
              <div class="title">Pedido #<?= (int)$o['id'] ?></div>
              <div class="muted" style="font-size:13px"><?=htmlspecialchars($o['created_at'] ?? '')?></div>
            </div>
            <div style="text-align:right">
              <div style="font-weight:700;color:#7be5ff">$<?=number_format(((int)($o['amount_cents'] ?? 0))/100,2)?></div>
              <div class="muted" style="font-size:12px"><?=htmlspecialchars($o['status'] ?? 'pending')?></div>
            </div>
          </div>
        <?php endforeach; ?>
      </div>
    <?php endif; ?>
  </section>
</div>
<?php include __DIR__ . '/footer.php'; ?>
