<?php include __DIR__ . '/header.php'; ?>
<div class="panel-layout">
  <?php include __DIR__ . '/panel_sidebar.php'; ?>
  <section class="panel-main">
    <div class="hero">
      <div>
        <h2>Organizar Evento</h2>
        <p>Captura la información del evento según el tipo de invitación seleccionado.</p>
      </div>
    </div>

    <?php if (!empty($plannerMsg)): ?>
      <div class="notice <?=($plannerMsg['type'] === 'ok' ? 'ok' : 'error')?>" style="margin-bottom:14px"><?=htmlspecialchars($plannerMsg['text'])?></div>
    <?php endif; ?>

    <div class="card-tech">
      <form method="post" class="stack">
        <?php if (!empty($selectedProduct)): ?>
          <label class="field">Invitación elegida
            <input type="text" value="<?=htmlspecialchars((string)$selectedProduct['title'])?>" readonly>
          </label>
        <?php endif; ?>
        <?php if (!empty($inferredEventTypeCode)): ?>
          <label class="field">Tipo de invitación detectado por producto
            <input type="text" value="<?=htmlspecialchars((string)($resolvedEventTypeLabel ?? ''))?>" readonly>
          </label>
        <?php else: ?>
          <label class="field">Tipo de invitación
            <select name="event_type_code" required>
              <option value="">Selecciona una opción</option>
              <?php foreach (($eventTypes ?? []) as $type): ?>
                <?php $code = (string)($type['code'] ?? ''); ?>
                <option value="<?=htmlspecialchars($code)?>" <?=((string)($resolvedEventTypeCode ?? ($eventData['event_type_code'] ?? '')) === $code ? 'selected' : '')?>>
                  <?=htmlspecialchars((string)($type['label'] ?? $code))?>
                </option>
              <?php endforeach; ?>
            </select>
          </label>
        <?php endif; ?>
        <label class="field">Título del evento
          <input type="text" name="title" required value="<?=htmlspecialchars((string)($eventData['title'] ?? ''))?>">
        </label>
        <label class="field">Fecha
          <input type="date" name="event_date" value="<?=htmlspecialchars((string)($eventData['event_date'] ?? ''))?>">
        </label>
        <label class="field">Lugar
          <input type="text" name="venue" value="<?=htmlspecialchars((string)($eventData['venue'] ?? ''))?>">
        </label>
        <label class="field">Notas de organización
          <textarea name="notes" rows="5"><?=htmlspecialchars((string)($eventData['notes'] ?? ''))?></textarea>
        </label>

        <?php if (!empty($dynamicFields)): ?>
          <h3 style="margin:10px 0 0">Datos de la invitación</h3>
          <?php foreach ($dynamicFields as $field): ?>
            <?php
              $fieldKey = (string)($field['field_key'] ?? '');
              $fieldLabel = (string)($field['field_label'] ?? $fieldKey);
              $fieldType = (string)($field['input_type'] ?? 'text');
              $isRequired = (int)($field['is_required'] ?? 0) === 1;
              $fieldValue = (string)($eventDetails[$fieldKey] ?? '');
              $placeholder = (string)($field['placeholder'] ?? '');
              $options = [];
              if (!empty($field['options_json'])) {
                $decoded = json_decode((string)$field['options_json'], true);
                if (is_array($decoded)) {
                  $options = $decoded;
                }
              }
            ?>
            <?php if ($fieldType === 'textarea'): ?>
              <label class="field"><?=htmlspecialchars($fieldLabel)?><?=$isRequired ? ' *' : ''?>
                <textarea name="details[<?=htmlspecialchars($fieldKey)?>]" rows="4" <?=$isRequired ? 'required' : ''?> placeholder="<?=htmlspecialchars($placeholder)?>"><?=htmlspecialchars($fieldValue)?></textarea>
              </label>
            <?php elseif ($fieldType === 'select'): ?>
              <label class="field"><?=htmlspecialchars($fieldLabel)?><?=$isRequired ? ' *' : ''?>
                <select name="details[<?=htmlspecialchars($fieldKey)?>]" <?=$isRequired ? 'required' : ''?>>
                  <option value="">Selecciona</option>
                  <?php foreach ($options as $opt): ?>
                    <?php $optValue = (string)$opt; ?>
                    <option value="<?=htmlspecialchars($optValue)?>" <?=($fieldValue === $optValue ? 'selected' : '')?>><?=htmlspecialchars($optValue)?></option>
                  <?php endforeach; ?>
                </select>
              </label>
            <?php elseif ($fieldType === 'boolean'): ?>
              <label class="field"><?=htmlspecialchars($fieldLabel)?>
                <select name="details[<?=htmlspecialchars($fieldKey)?>]" <?=$isRequired ? 'required' : ''?>>
                  <option value="">Selecciona</option>
                  <option value="1" <?=($fieldValue === '1' ? 'selected' : '')?>>Sí</option>
                  <option value="0" <?=($fieldValue === '0' ? 'selected' : '')?>>No</option>
                </select>
              </label>
            <?php else: ?>
              <label class="field"><?=htmlspecialchars($fieldLabel)?><?=$isRequired ? ' *' : ''?>
                <input type="<?=htmlspecialchars(in_array($fieldType, ['text', 'number', 'date', 'time', 'url'], true) ? $fieldType : 'text')?>" name="details[<?=htmlspecialchars($fieldKey)?>]" value="<?=htmlspecialchars($fieldValue)?>" <?=$isRequired ? 'required' : ''?> placeholder="<?=htmlspecialchars($placeholder)?>">
              </label>
            <?php endif; ?>
          <?php endforeach; ?>
        <?php endif; ?>
        <button class="btn primary" type="submit" style="max-width:240px">Guardar configuración</button>
      </form>
    </div>
  </section>
</div>
<?php include __DIR__ . '/footer.php'; ?>
