<?php include __DIR__ . '/header.php'; ?>
<div class="panel-layout">
  <?php include __DIR__ . '/panel_sidebar.php'; ?>
  <section class="panel-main">
    <div class="hero">
      <div>
        <h2>Subir Invitados</h2>
        <p>Carga invitados por formulario o CSV (columnas: name, phone, email, adults, kids).</p>
      </div>
    </div>

    <?php if (empty($eventId)): ?>
      <div class="notice error" style="margin-bottom:14px">Primero debes configurar tu invitación y evento en "Organizar Evento".</div>
    <?php endif; ?>

    <?php if (!empty($guestMsg)): ?>
      <div class="notice <?=($guestMsg['type'] === 'ok' ? 'ok' : 'error')?>" style="margin-bottom:14px"><?=htmlspecialchars($guestMsg['text'])?></div>
    <?php endif; ?>

    <div class="split">
      <div class="card-tech">
        <h3 style="margin-top:0">Agregar invitado manual</h3>
        <form method="post" class="stack">
          <input type="hidden" name="mode" value="manual">
          <input type="text" name="name" placeholder="Nombre completo" required <?=empty($eventId) ? 'disabled' : ''?>>
          <input type="text" name="phone" placeholder="Teléfono">
          <input type="email" name="email" placeholder="Email">
          <div class="split">
            <input type="number" name="adults" min="1" value="1" placeholder="Adultos">
            <input type="number" name="kids" min="0" value="0" placeholder="Niños">
          </div>
          <button class="btn primary" type="submit" <?=empty($eventId) ? 'disabled' : ''?>>Guardar invitado</button>
        </form>
      </div>

      <div class="card-tech">
        <h3 style="margin-top:0">Importar CSV</h3>
        <form method="post" enctype="multipart/form-data" class="stack">
          <input type="hidden" name="mode" value="csv">
          <input type="file" name="csv" accept=".csv,text/csv" required <?=empty($eventId) ? 'disabled' : ''?>>
          <button class="btn ghost" type="submit" <?=empty($eventId) ? 'disabled' : ''?>>Importar archivo</button>
        </form>
      </div>
    </div>

    <div class="card-tech" style="margin-top:16px">
      <h3 style="margin-top:0">Lista de invitados (<?=count($guests)?>)</h3>
      <?php if (empty($guests)): ?>
        <p class="muted">Aún no hay invitados cargados.</p>
      <?php else: ?>
        <div class="list-grid">
          <?php foreach ($guests as $g): ?>
            <div class="list-item">
              <div>
                <strong><?=htmlspecialchars($g['name'])?></strong>
                <div class="muted" style="font-size:13px"><?=htmlspecialchars((string)($g['phone'] ?? ''))?> <?=!empty($g['email']) ? '• ' . htmlspecialchars($g['email']) : ''?></div>
                <div class="muted" style="font-size:12px"><?=!empty($g['invite_sent_at']) ? 'Enviado: ' . htmlspecialchars((string)$g['invite_sent_at']) : 'Pendiente de envío'?></div>
              </div>
              <div class="muted" style="font-size:13px">Adultos: <?= (int)$g['adults'] ?> | Niños: <?= (int)$g['kids'] ?></div>
            </div>
          <?php endforeach; ?>
        </div>
      <?php endif; ?>
    </div>
  </section>
</div>
<?php include __DIR__ . '/footer.php'; ?>
