<!doctype html>
<html lang="es">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Tienda de Invitaciones</title>
  <?php $cssVersion = @filemtime(__DIR__ . '/../public/assets/styles.css') ?: time(); ?>
  <link rel="stylesheet" href="<?=htmlspecialchars($url('/assets/styles.css', ['v' => $cssVersion]))?>">
  <meta name="theme-color" content="#071022">
</head>
<body>
<div class="site">
<?php
$currentPath = isset($path) ? (string)$path : '/';
$isActive = static function ($route) use ($currentPath) {
  return $currentPath === $route ? ' is-active' : '';
};
?>
<?php if (!empty($currentUser)): ?>
  <div class="user-topbar">
    <div class="meta">
      <span class="meta-ico" aria-hidden="true">
        <svg viewBox="0 0 24 24"><path d="M20 21a8 8 0 10-16 0M12 11a4 4 0 100-8 4 4 0 000 8z" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round"/></svg>
      </span>
      <strong>Usuario:</strong> <?=htmlspecialchars($currentUser['name'] ?? '')?>
    </div>
    <div class="meta">
      <span class="meta-ico" aria-hidden="true">
        <svg viewBox="0 0 24 24"><path d="M12 7v5l3 2M21 12a9 9 0 11-18 0 9 9 0 0118 0z" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/></svg>
      </span>
      <strong>Horario:</strong> <span id="live-clock">--:--:--</span>
    </div>
    <div class="actions">
      <a href="<?=htmlspecialchars($url('/switch-user'))?>">
        <span class="nav-ico" aria-hidden="true">
          <svg viewBox="0 0 24 24"><path d="M7 7h10M7 12h10M7 17h10" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round"/></svg>
        </span>
        <span>Cambiar usuario</span>
      </a>
      <a class="danger" href="<?=htmlspecialchars($url('/logout'))?>">
        <span class="nav-ico" aria-hidden="true">
          <svg viewBox="0 0 24 24"><path d="M15 8l4 4-4 4M19 12H9M11 4H6a2 2 0 00-2 2v12a2 2 0 002 2h5" fill="none" stroke="currentColor" stroke-width="1.8" stroke-linecap="round" stroke-linejoin="round"/></svg>
        </span>
        <span>Cerrar sesión</span>
      </a>
    </div>
  </div>
<?php endif; ?>
<header>
  <div class="brand">
    <div class="logo">IV</div>
    <div>
      <h1>Tienda Invitaciones</h1>
      <div style="font-size:12px;color:var(--text-muted)">Diseño emocional · Alta tecnología</div>
    </div>
  </div>
  <button class="menu-toggle" type="button" aria-expanded="false" aria-controls="top-nav" aria-label="Abrir menú">
    <span></span><span></span><span></span>
  </button>
  <nav id="top-nav" class="top-nav">
    <a class="btn nav-pill<?=$isActive('/')?>" href="<?=htmlspecialchars($url('/'))?>">
      <span class="nav-ico" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M3 11l9-7 9 7v9a1 1 0 01-1 1h-5v-6H9v6H4a1 1 0 01-1-1z" fill="none" stroke="currentColor" stroke-width="1.7" stroke-linejoin="round"/></svg></span>
      <span>Catálogo</span>
    </a>
    <a class="btn nav-pill<?=$isActive('/cart')?>" href="<?=htmlspecialchars($url('/cart'))?>">
      <span class="nav-ico" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M4 5h2l2 11h10l2-8H7M10 20a1 1 0 100 2 1 1 0 000-2zm8 0a1 1 0 100 2 1 1 0 000-2z" fill="none" stroke="currentColor" stroke-width="1.7" stroke-linecap="round" stroke-linejoin="round"/></svg></span>
      <span>Carrito</span>
    </a>
    <a class="btn nav-pill<?=$isActive('/orders')?>" href="<?=htmlspecialchars($url('/orders'))?>">
      <span class="nav-ico" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M6 4h12a2 2 0 012 2v12l-4-2-4 2-4-2-4 2V6a2 2 0 012-2z" fill="none" stroke="currentColor" stroke-width="1.7" stroke-linejoin="round"/></svg></span>
      <span>Pedidos</span>
    </a>
    <?php if (!empty($currentUser)): ?>
      <a class="btn nav-pill<?=$isActive('/dashboard')?>" href="<?=htmlspecialchars($url('/dashboard'))?>">
        <span class="nav-ico" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M4 13h6v7H4zm10-9h6v16h-6zM4 4h6v7H4z" fill="none" stroke="currentColor" stroke-width="1.7" stroke-linejoin="round"/></svg></span>
        <span>Dashboard</span>
      </a>
    <?php else: ?>
      <a class="btn nav-pill<?=$isActive('/login')?>" href="<?=htmlspecialchars($url('/login'))?>">
        <span class="nav-ico" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M10 17l-5-5 5-5M5 12h10M14 4h4a2 2 0 012 2v12a2 2 0 01-2 2h-4" fill="none" stroke="currentColor" stroke-width="1.7" stroke-linecap="round" stroke-linejoin="round"/></svg></span>
        <span>Ingresar</span>
      </a>
      <a class="btn nav-pill<?=$isActive('/register')?>" href="<?=htmlspecialchars($url('/register'))?>">
        <span class="nav-ico" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M12 5v14M5 12h14" fill="none" stroke="currentColor" stroke-width="1.7" stroke-linecap="round"/></svg></span>
        <span>Crear Cuenta</span>
      </a>
    <?php endif; ?>
    <a class="btn nav-pill<?=$isActive('/admin')?>" href="<?=htmlspecialchars($url('/admin'))?>">
      <span class="nav-ico" aria-hidden="true"><svg viewBox="0 0 24 24"><path d="M12 2l3 3 4 .5.5 4 3 3-3 3-.5 4-4 .5-3 3-3-3-4-.5-.5-4-3-3 3-3 .5-4 4-.5zM12 9a3 3 0 100 6 3 3 0 000-6z" fill="none" stroke="currentColor" stroke-width="1.6" stroke-linejoin="round"/></svg></span>
      <span>Admin</span>
    </a>
  </nav>
</header>
<script>
  (function () {
    var button = document.querySelector('.menu-toggle');
    var nav = document.getElementById('top-nav');
    if (!button || !nav) return;

    button.addEventListener('click', function () {
      var opened = nav.classList.toggle('is-open');
      button.classList.toggle('is-open', opened);
      button.setAttribute('aria-expanded', opened ? 'true' : 'false');
    });

    var links = nav.querySelectorAll('a');
    for (var i = 0; i < links.length; i++) {
      links[i].addEventListener('click', function () {
        if (window.matchMedia('(max-width: 980px)').matches) {
          nav.classList.remove('is-open');
          button.classList.remove('is-open');
          button.setAttribute('aria-expanded', 'false');
        }
      });
    }
  })();

  (function () {
    var el = document.getElementById('live-clock');
    if (!el) return;
    var pad = function (n) { return n < 10 ? '0' + n : '' + n; };
    var tick = function () {
      var d = new Date();
      el.textContent = pad(d.getHours()) + ':' + pad(d.getMinutes()) + ':' + pad(d.getSeconds());
    };
    tick();
    setInterval(tick, 1000);
  })();
</script>
<main>
