<?php include __DIR__ . '/header.php'; ?>
<section class="promo-bar">
  <span class="dot"></span>
  <span>Nuevo: panel de cliente con dashboard y control de pedidos.</span>
  <a href="<?=htmlspecialchars($url('/register'))?>">Probar ahora</a>
</section>

<?php if (!empty($catalogNotice)): ?>
  <div class="notice error" style="margin:0 0 14px"><?=htmlspecialchars($catalogNotice)?></div>
<?php endif; ?>

<section class="hero hero-v2">
  <div class="hero-copy">
    <h2 class="hero-title-special">Invitaciones digitales<br>para <span class="hero-red">tu ocasión especial</span>.</h2>
    <p>
      Diseña, publica y gestiona invitaciones digitales con una experiencia premium.
      Controla invitados, pagos y seguimiento desde un solo lugar.
    </p>
    <div class="hero-ctas">
      <a class="btn primary" href="<?=htmlspecialchars($url('/register'))?>">Comenzar Gratis</a>
      <a class="btn ghost" href="<?=htmlspecialchars($url('/dashboard'))?>">Ver Dashboard</a>
    </div>
    <div class="hero-links">
      <a href="<?=htmlspecialchars($url('/login'))?>">Iniciar sesión</a>
      <a href="<?=htmlspecialchars($url('/orders'))?>">Mis pedidos</a>
      <a href="<?=htmlspecialchars($url('/admin'))?>">Panel admin</a>
    </div>
  </div>
  <div class="hero-panel">
    <div class="panel-body">
      <div class="hero-shot">
        <img src="<?=htmlspecialchars($url('/assets/imagen2.png'))?>" alt="Invitación destacada">
      </div>
    </div>
  </div>
</section>

<section class="events-gallery">
  <h2>Para todo tipo de eventos.</h2>
  <p>Mira algunos <strong>ejemplos</strong> para tu ocasión especial.</p>
  <div class="events-grid">
    <article class="event-card" data-event-card>
      <span class="event-label">Para</span>
      <h3>Bodas</h3>
      <button class="event-arrow-btn" type="button" aria-label="Seleccionar Bodas">→</button>
    </article>
    <article class="event-card" data-event-card>
      <span class="event-label">Para</span>
      <h3>XV años</h3>
      <button class="event-arrow-btn" type="button" aria-label="Seleccionar XV años">→</button>
    </article>
    <article class="event-card" data-event-card>
      <span class="event-label">Para</span>
      <h3>Graduaciones</h3>
      <button class="event-arrow-btn" type="button" aria-label="Seleccionar Graduaciones">→</button>
    </article>
    <article class="event-card" data-event-card>
      <span class="event-label">Para</span>
      <h3>Cumpleaños</h3>
      <button class="event-arrow-btn" type="button" aria-label="Seleccionar Cumpleaños">→</button>
    </article>
    <article class="event-card" data-event-card>
      <span class="event-label">Para</span>
      <h3>Bautizos</h3>
      <button class="event-arrow-btn" type="button" aria-label="Seleccionar Bautizos">→</button>
    </article>
    <article class="event-card event-card-highlight" data-event-card>
      <span class="event-label">Para</span>
      <h3>Primeras Comuniones</h3>
      <button class="event-arrow-btn" type="button" aria-label="Seleccionar Primeras Comuniones">→</button>
    </article>
  </div>
</section>
<script>
  (function () {
    var cards = document.querySelectorAll('[data-event-card]');
    if (!cards.length) return;
    for (var i = 0; i < cards.length; i++) {
      cards[i].addEventListener('click', function () {
        for (var j = 0; j < cards.length; j++) cards[j].classList.remove('is-selected');
        this.classList.add('is-selected');
      });
    }
  })();
</script>

<section class="capabilities">
  <article>
    <h3>Personalización dinámica</h3>
    <p>Adapta el contenido por tipo de evento con estructura flexible y elegante.</p>
  </article>
  <article>
    <h3>Gestión de invitados</h3>
    <p>Centraliza pases, RSVP y estados de asistencia desde un flujo simple.</p>
  </article>
  <article>
    <h3>Operación profesional</h3>
    <p>Dashboard de cliente, panel admin y métricas para decisiones rápidas.</p>
  </article>
</section>

<section class="hero" style="margin-bottom:24px">
  <div>
    <h2>Plantillas disponibles</h2>
    <p>Elige un diseño y publícalo hoy mismo.</p>
  </div>
</section>

<div class="products">
<?php $productIndex = 0; ?>
<?php
$resolveProductImage = static function ($rawImage) use ($url) {
  $rawImage = trim((string)$rawImage);
  if ($rawImage === '') {
    return '';
  }
  if (preg_match('#^(https?:)?//#i', $rawImage) || strpos($rawImage, 'data:') === 0) {
    return $rawImage;
  }
  if (strpos($rawImage, '/assets/') === 0) {
    return $url($rawImage);
  }
  return $url('/' . ltrim($rawImage, '/'));
};
?>
<?php foreach ($products as $p): ?>
  <?php
    $productIndex++;
    $productLabel = 'Producto ' . $productIndex;
    $rawImage = trim((string)($p['image_url'] ?? ''));
    $resolvedImage = $resolveProductImage($rawImage);
    $productImage = $resolvedImage !== '' ? $resolvedImage : (($productIndex === 1) ? $url('/assets/imagen1.png') : $url('/assets/imagen2.png'));
  ?>
  <article class="product">
    <div class="media" style="padding:0;overflow:hidden">
      <img src="<?=htmlspecialchars($productImage)?>" alt="<?=htmlspecialchars($productLabel)?>" style="width:100%;height:100%;object-fit:cover;display:block">
    </div>
    <h3><?=htmlspecialchars($productLabel)?></h3>
    <p><?=htmlspecialchars($p['description'])?></p>
    <div class="price">$<?=number_format($p['price_cents']/100,2)?></div>
    <div class="actions">
      <a class="btn ghost" href="<?=htmlspecialchars($url('/product', ['id' => (int)$p['id']]))?>">Ver Detalles</a>
      <?php if (!empty($currentUser)): ?>
        <form style="display:inline;flex:1" method="post" action="<?=htmlspecialchars($url('/seleccionar-invitacion'))?>">
          <input type="hidden" name="id" value="<?=$p['id']?>">
          <button class="btn ghost" type="submit" style="width:100%">Seleccionar para evento</button>
        </form>
      <?php endif; ?>
      <form style="display:inline;flex:1" method="post" action="<?=htmlspecialchars($url('/add-to-cart'))?>">
        <input type="hidden" name="id" value="<?=$p['id']?>">
        <button class="btn primary" type="submit" style="width:100%">Añadir</button>
      </form>
    </div>
  </article>
<?php endforeach; ?>
</div>

<section class="final-cta">
  <h3>Listo para lanzar tu próxima invitación digital</h3>
  <p>Empieza en minutos y escala tu operación de eventos sin fricción.</p>
  <div>
    <a class="btn primary" href="<?=htmlspecialchars($url('/register'))?>">Crear Cuenta</a>
    <a class="btn ghost" href="<?=htmlspecialchars($url('/login'))?>">Ya tengo cuenta</a>
  </div>
</section>
<?php include __DIR__ . '/footer.php'; ?>

