<?php include __DIR__ . '/header.php'; ?>
<div class="hero">
  <div>
    <h2>Mis Pedidos</h2>
    <p>Historial y estado de tus compras</p>
  </div>
</div>

<?php if (empty($orders)): ?>
  <div class="card-tech empty-state">
    <svg width="64" height="64" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-bottom:20px;opacity:0.5"><path d="M9 2L6 6M15 2L18 6M3 6H21L19 20C19 20.5304 18.7893 21.0391 18.4142 21.4142C18.0391 21.7893 17.5304 22 17 22H7C6.46957 22 5.96086 21.7893 5.58579 21.4142C5.21071 21.0391 5 20.5304 5 20L3 6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>
    <h3 class="muted" style="margin-bottom:20px">Aún no tienes pedidos</h3>
    <a href="<?=htmlspecialchars($url('/'))?>" class="btn primary" style="display:inline-flex;width:auto">Ir al Catálogo</a>
  </div>
<?php else: ?>
  <div class="list-grid">
    <?php foreach ($orders as $o): ?>
      <div class="list-item">
        <div>
          <div class="title" style="margin-bottom:8px">Pedido #<?=htmlspecialchars($o['id'])?></div>
          <div class="muted" style="font-size:13px">Stripe session: <code><?=substr(htmlspecialchars($o['stripe_session_id']),0,16)?>...</code></div>
          <div class="muted" style="font-size:13px;margin-top:6px"><?=htmlspecialchars($o['created_at'] ?? 'N/A')?></div>
        </div>
        <div style="text-align:right">
          <div style="color:#7be5ff;font-weight:700;font-size:18px;margin-bottom:8px">$<?=number_format(($o['amount_cents'] ?? 0)/100,2)?></div>
          <span class="status-pill"><?=htmlspecialchars($o['status'])?></span>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
<?php endif; ?>
<?php include __DIR__ . '/footer.php'; ?>
