<?php include __DIR__ . '/header.php'; ?>
<div class="page-wrap">
  <a class="back-link" href="<?=htmlspecialchars($url('/'))?>">← Volver al catálogo</a>
  <article class="card-tech split">
    <div class="media" style="margin-bottom:0">
      <svg width="100" height="100" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="opacity:0.7"><path d="M3 7h18v10H3z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/></svg>
    </div>
    <div class="stack">
      <h1 style="margin:0"><?=htmlspecialchars($product['title'])?></h1>
      <p class="muted" style="margin:0"><?=nl2br(htmlspecialchars($product['description']))?></p>
      <div class="stat-box">
        <div class="label">Precio por unidad</div>
        <div class="value">$<?=number_format($product['price_cents']/100,2)?></div>
      </div>
      <form action="<?=htmlspecialchars($url('/add-to-cart'))?>" method="post" class="stack">
        <input type="hidden" name="id" value="<?=$product['id']?>">
        <label class="field">Cantidad de invitaciones
          <input type="number" name="qty" value="1" min="1" max="999" required>
        </label>
        <button class="btn primary" type="submit">Añadir al Carrito</button>
        <a class="btn ghost" href="<?=htmlspecialchars($url('/cart'))?>">Ver Carrito</a>
      </form>
    </div>
  </article>
</div>
<?php include __DIR__ . '/footer.php'; ?>
