<?php include __DIR__ . '/header.php'; ?>
<div class="page-wrap narrow">
  <div class="hero"><div><h2>Crear cuenta</h2><p>Regístrate para administrar tus pedidos.</p></div></div>
  <div class="card-tech">
    <?php if (!empty($authError)): ?>
      <div class="notice error" style="margin-bottom:14px"><?=htmlspecialchars($authError)?></div>
    <?php endif; ?>
    <form method="post" action="<?=htmlspecialchars($url('/register'))?>" class="stack">
      <?php $next = (string)($_GET['next'] ?? ''); ?>
      <?php if ($next !== ''): ?>
        <input type="hidden" name="next" value="<?=htmlspecialchars($next)?>">
      <?php endif; ?>
      <label class="field">Nombre
        <input type="text" name="name" required>
      </label>
      <label class="field">Email
        <input type="email" name="email" required>
      </label>
      <label class="field">Contraseña (mínimo 6)
        <input type="password" name="password" minlength="6" required>
      </label>
      <button class="btn primary" type="submit" style="width:100%">Crear cuenta</button>
    </form>
    <p class="muted" style="margin-top:12px">¿Ya tienes cuenta? <a href="<?=htmlspecialchars($url('/login'))?>">Inicia sesión</a></p>
  </div>
</div>
<?php include __DIR__ . '/footer.php'; ?>
