<?php include __DIR__ . '/header.php'; ?>
<div class="panel-layout">
  <?php include __DIR__ . '/panel_sidebar.php'; ?>
  <section class="panel-main">
    <div class="hero">
      <div>
        <h2>Enviar Invitaciones</h2>
        <p>Envía tus invitaciones por WhatsApp o marca envío masivo.</p>
      </div>
    </div>

    <?php if (!empty($sendMsg)): ?>
      <div class="notice <?=($sendMsg['type'] === 'ok' ? 'ok' : 'error')?>" style="margin-bottom:14px"><?=htmlspecialchars($sendMsg['text'])?></div>
    <?php endif; ?>

    <?php if (empty($eventId)): ?>
      <div class="card-tech">
        <p class="muted" style="margin:0 0 10px">No tienes evento configurado todavía.</p>
        <a class="btn primary" style="max-width:240px" href="<?=htmlspecialchars($url('/organizar-evento'))?>">Configurar evento</a>
      </div>
    <?php else: ?>
      <div class="card-tech" style="margin-bottom:14px">
        <form method="post">
          <button class="btn primary" type="submit" style="max-width:280px">Marcar envío masivo</button>
        </form>
      </div>

      <div class="card-tech">
        <h3 style="margin-top:0">Invitados (<?=count($guests)?>)</h3>
        <?php if (empty($guests)): ?>
          <p class="muted">No hay invitados para enviar.</p>
        <?php else: ?>
          <div class="list-grid">
            <?php foreach ($guests as $g): ?>
              <?php
                $guestName = (string)($g['name'] ?? '');
                $phoneRaw = preg_replace('/[^0-9]/', '', (string)($g['phone'] ?? ''));
                $eventTitle = (string)($eventData['title'] ?? 'nuestro evento');
                $message = rawurlencode('Hola ' . $guestName . ', te compartimos tu invitación digital para ' . $eventTitle . '.');
                $waUrl = $phoneRaw !== '' ? 'https://wa.me/' . $phoneRaw . '?text=' . $message : '';
              ?>
              <div class="list-item">
                <div>
                  <strong><?=htmlspecialchars($guestName)?></strong>
                  <div class="muted" style="font-size:13px">
                    <?=htmlspecialchars((string)($g['phone'] ?? ''))?>
                    <?=!empty($g['email']) ? ' • ' . htmlspecialchars((string)$g['email']) : ''?>
                  </div>
                  <div class="muted" style="font-size:12px">
                    <?=!empty($g['invite_sent_at']) ? 'Enviado: ' . htmlspecialchars((string)$g['invite_sent_at']) : 'Pendiente de envío'?>
                  </div>
                </div>
                <?php if ($waUrl !== ''): ?>
                  <a class="btn ghost" style="max-width:180px" target="_blank" rel="noopener" href="<?=htmlspecialchars($waUrl)?>">Enviar WhatsApp</a>
                <?php else: ?>
                  <span class="muted" style="font-size:12px">Sin teléfono</span>
                <?php endif; ?>
              </div>
            <?php endforeach; ?>
          </div>
        <?php endif; ?>
      </div>
    <?php endif; ?>
  </section>
</div>
<?php include __DIR__ . '/footer.php'; ?>
